<form id="admin_user_create_update_form">
  <input type="hidden" name="user_id" value="<?php echo esc_output($user['user_id']); ?>" />
  <div class="modal-body">
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label>First Name</label>
          <input type="text" class="form-control" name="first_name" value="<?php echo esc_output($user['first_name']); ?>">
        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label>Last Name</label>
          <input type="text" class="form-control" name="last_name" value="<?php echo esc_output($user['last_name']); ?>">
        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label><?php echo lang('email'); ?></label>
          <input type="text" class="form-control" name="email" value="<?php echo esc_output($user['email']); ?>">
        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label><?php echo lang('username'); ?></label>
          <input type="text" class="form-control" name="username" value="<?php echo esc_output($user['username']); ?>">
        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label><?php echo lang('password'); ?></label>
          <input type="password" class="form-control" name="password">
        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label>Confirm Password</label>
          <input type="password" class="form-control" name="confirm_password">
        </div>
      </div>
      
      <div class="col-md-6">
        <div class="form-group">
          <label><?php echo lang('phone'); ?></label>
          <input type="text" class="form-control" name="phone" value="<?php echo esc_output($user['phone']); ?>">
        </div>
      </div>

      <div class="col-md-3">
        <div class="form-group">
          <label>User Type</label>
          <select class="form-control select2" id="user_type" name="user_type">
            <option value=""><?php echo lang('none'); ?></option>
            <option value="Flat Owner" <?php sel($user['user_type'], 'Flat Owner'); ?>>Flat Owner</option>
            <option value="Security" <?php sel($user['user_type'], 'Security'); ?>>Security</option>
          </select>
        </div>
      </div>
      <div class="col-md-3" id="flatdiv">
        <div class="form-group">
          <label>Flats</label>
          <select class="form-control select2" id="flat_id" name="flat_id">
            <option value=""><?php echo lang('none'); ?></option>
          </select>
        </div>
      </div>

      <div class="col-md-12">
        <div class="form-group">
          <label><?php echo lang('image'); ?></label>
          <input type="file" data-show-remove="false" class="form-control dropify" name="image" 
                data-default-file="<?php echo userThumb($user['image']); ?>" />
        </div>
      </div>
    </div>          
  </div>
  <div class="modal-footer">
    <button type="button" class="btn btn-default pull-left" data-dismiss="modal"><?php echo lang('close'); ?></button>
    <button type="submit" class="btn btn-primary btn-blue" id="admin_user_create_update_form_button"><?php echo lang('save'); ?></button>
  </div>
</form>
<script>
  var usertype = "<?php echo $user['user_type']; ?>";
  var flatid = "<?php echo $flat['flat_id']; ?>";
  if(usertype == 'Flat Owner')
  {
    console.log("view page")
    $.ajax({
        url : application.url+'admin/subscribers/flatList/',
        method : "GET",
        async : true,
        dataType : 'json',
        success: function(data){
            var html = '';
            var i;
            var location_text = 'None';
            html += '<option value="">'+location_text+'</option>';
            for(i=0; i<data.length; i++){
                if(flatid == data[i].flat_id)
                  html += '<option value='+data[i].flat_id+' selected>'+data[i].block_door+'</option>';
                else
                html += '<option value='+data[i].flat_id+'>'+data[i].block_door+'</option>';
            }
            $("#flatdiv").show();
            $('#flat_id').html(html);

        }
    });
  }
</script>
