<?php

class Pages extends CI_Controller
{
    function __construct() { 
        parent::__construct(); 
         
        // Load pagination library 
        $this->load->library('ajax_pagination'); 
    } 
    /**
     * View Function to display home page
     *
     * @return html/string
     */
    public function index($page = null)
    {
        redirect('admin');
    }
    
    
    /**
     * Post function to create schema and import data during installation
     *
     * @return void
     */
    public function createSchemaAndImportData()
    {   
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        ini_set('max_execution_time', 1000);
        try {
            $this->SchemaModel->run();
            $this->SchemaQuestionsModel->run();
            $this->DataQuestionsModel->run();
            $this->DataModel->run();
            $message = 'success';
        } catch (Exception $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Function (for ajax) to create admin user form request (from installation)
     *
     * @return redirect
     */
    public function createAdminUser($data = array())
    {
        $this->form_validation->set_rules('first_name', 'First Name', 'required|min_length[2]|max_length[20]');
        $this->form_validation->set_rules('last_name', 'Last Name', 'required|min_length[2]|max_length[20]');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[users.email]');
        $this->form_validation->set_rules('password', 'Password', 'required');
        $this->form_validation->set_rules('retype_password', 'Confirm Password', 'required|matches[password]');

        if ($this->form_validation->run() === FALSE) {
            return validation_errors();
        } else {
            $this->AdminUserModel->storeAdminUser($data);
            return 'success';
        }
    }    

    /**
     * Function to save session variable for sidebar goggle
     *
     * @return void
     */
    public function sidebarToggle()
    {
        $currentValue = $this->sess('sidebar-toggle');
        $currentValue = $currentValue == 'off' ? 'on' : 'off';
        $this->session->set_userdata('sidebar-toggle', $currentValue);
    }

    /**
     * Function to display default 404 page on 404 error
     *
     * @return void
     */
    public function notFoundPage()
    {   
        $data['page'] = setting('site-name').' | page not found';
        $this->load->view('front/layout/header', $data);
        $this->load->view('front/404');
    }

}
