<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/

//Admin User(outer) routes

$route['/'] = 'admin/users/loginView';
$route['admin'] = 'admin/users/loginView';
$route['admin/login'] = 'admin/users/loginView';
$route['admin/login-post'] = 'admin/users/login';
$route['admin/forgot-password'] = 'admin/users/forgotPasswordView';
$route['admin/forgot-password-post'] = 'admin/users/forgotPassword';
$route['admin/reset-password/(:any)'] = 'admin/users/resetPasswordView/$1';
$route['admin/reset-password-post'] = 'admin/users/resetPassword';

//Admin User(inner) routes
$route['admin/profile'] = 'admin/users/profile';
$route['admin/password'] = 'admin/users/passwordView';
$route['admin/profile-post'] = 'admin/users/updateProfile';
$route['admin/password-post'] = 'admin/users/updatePassword';
$route['admin/logout'] = 'admin/users/logout';
$route['admin/settings/general'] = 'admin/settings/general';
$route['admin/settings/apis'] = 'admin/settings/apis';
$route['admin/settings/css'] = 'admin/settings/css';
$route['admin/settings/languages'] = 'admin/settings/languages';
$route['admin/settings/home'] = 'admin/settings/home';
$route['admin/settings/save'] = 'admin/settings/updateSettings';
$route['admin/settings/update-css'] = 'admin/settings/updateCss';

//Admin Users module routes
$route['admin/users'] = 'admin/users/usersListView';
$route['admin/users/data'] = 'admin/users/usersList';
$route['admin/users/create-or-edit'] = 'admin/users/createOrEditUser';
$route['admin/users/create-or-edit/(:any)'] = 'admin/users/createOrEditUser/$1';
$route['admin/users/message-user/(:any)'] = 'admin/users/messageUser/$1';
$route['admin/users/message-user-save'] = 'admin/users/messageUserSave/$1';
$route['admin/users/save'] = 'admin/users/saveUser';
$route['admin/users/save-roles'] = 'admin/users/saveUserRoles';
$route['admin/users/status/(:any)/(:any)'] = 'admin/users/changeStatus/$1/$2';
$route['admin/users/bulk-action'] = 'admin/users/bulkAction';
$route['admin/users/delete/(:any)'] = 'admin/users/delete/$1';

//Admin Languages module routes
$route['admin/languages'] = 'admin/languages/listView';
$route['admin/languages/data'] = 'admin/languages/data';
$route['admin/languages/create'] = 'admin/languages/create';
$route['admin/languages/edit/(:any)'] = 'admin/languages/edit/$1';
$route['admin/languages/save'] = 'admin/languages/save';
$route['admin/languages/update'] = 'admin/languages/update';
$route['admin/languages/status/(:any)/(:any)'] = 'admin/languages/changeStatus/$1/$2';
$route['admin/languages/selected/(:any)'] = 'admin/languages/changeSelected/$1';
$route['admin/languages/bulk-action'] = 'admin/languages/bulkAction';
$route['admin/languages/delete/(:any)'] = 'admin/languages/delete/$1';

//Admin Dashboard Routes
$route['admin/dashboard'] = 'admin/dashboard/index';
$route['admin/dashboard/popular-jobs-data'] = 'admin/dashboard/popularJobsChartData';
$route['admin/dashboard/top-candidates-data'] = 'admin/dashboard/topCandidatesChartData';
$route['admin/dashboard/jobs-list'] = 'admin/dashboard/jobsList';

//Admin subscribers module routes
$route['admin/subscribers/createOrEdit'] = 'admin/subscribers/createOrEdit';
$route['admin/subscribers/save'] = 'admin/subscribers/saveVisitor';
$route['admin/subscribers'] = 'admin/subscribers/subscribersListView';
$route['admin/subscribers/data'] = 'admin/subscribers/subscribersList';
$route['admin/subscribers/saveEntry'] = 'admin/subscribers/saveEntry';
$route['admin/subscribers/entry'] = 'admin/subscribers/entryListView';
$route['admin/subscribers/entrydata'] = 'admin/subscribers/entryList';
$route['admin/subscribers/flatList'] = 'admin/subscribers/flatList';
$route['admin/subscribers/getFlatOwner/(:any)'] = 'admin/subscribers/getFlatOwner/$1';



$route['admin/vfilter'] = 'admin/subscribers/subscribersFilterView';
$route['admin/vfilterajax'] = 'admin/subscribers/ajaxFilterView';
$route['admin/subscribers/changetime/(:any)/(:any)'] = 'admin/subscribers/changetime/$1/$2';
$route['admin/subscribers/view/(:any)'] = 'admin/subscribers/view/$1';
$route['admin/subscribers/excel'] = 'admin/subscribers/candidatesExcel';


//Admin General routes
$route['admin/ckeditor/images/upload'] = 'admin/blogs/uploadCkEditorImages';
$route['admin/sidebar-toggle'] = 'pages/sidebarToggle';

//Admin Footer section modue
$route['admin/footer-sections'] = 'admin/FooterSections/index';
$route['admin/footer-sections/save'] = 'admin/FooterSections/save';

//Installation and other routes
$route['admin-user'] = 'admin/users/createAdminUser';
$route['encrypt-files'] = 'admin/settings/encryptFiles';
$route['schema'] = 'schema/run';
$route['import-data'] = 'schema/data';
$route['complete-install'] = 'pages/createSchemaAndImportData';
$route['default_controller'] = 'pages/index';
$route['404_override'] = 'pages/notFoundPage';
$route['translate_uri_dashes'] = FALSE;

